import pandas as pd   
import matplotlib.pyplot as plt   
import seaborn as sns 
   
# Load the dataset   
credit_customers = pd.read_csv("credit_customers.csv")   

# Plot scatter plots  
fig, axes = plt.subplots(2, 2, figsize=(12, 8))  
  
sns.scatterplot(data=credit_customers_numerical, x='age', y='class_binary', ax=axes[1, 0])   
axes[1, 0].set_title('Loan Approval Rates vs. Age')   

sns.scatterplot(data=credit_customers_numerical, x='credit_amount', y='class_binary', ax=axes[1, 1])   
axes[1, 1].set_title('Loan Approval Rates vs. Credit Amount')   

plt.tight_layout()  
plt.savefig('ref_result/scatterplot_3.png')
plt.show() 

  